<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

<xsl:output method="html" indent="yes" encoding="ISO-8859-1" version="4.0"/>
<xsl:template match="/">
 <html>
   <head>
      <meta name="robots" content="noindex" />
      <meta name="generator" content="GENEREX GmbH" />
      <link rel="stylesheet" type="text/css" href="gxNMS.css" />
      <title>Conceptpower Eventlog</title>

   </head>
   <xsl:element name="body">
		<xsl:apply-templates />
   </xsl:element>
 </html>
</xsl:template>

<xsl:template match="eventlog">
	<center>
	<h2 class="XLargeBold" style="color:#405080;">Event Logfile</h2>
<!--	<xsl:apply-templates select="document('lista_codici.xml')" />--><br/><br/>
	<table cellspacing="2" cellpadding="1" border="0" borderColor="#000000">
	<tbody>
		<tr>
			<th class="LargeBold" width="200" align="left" bgColor="#405080" style = "color:#ffffff;text-align:center;">Time</th>
			<th class="LargeBold" width="20" align="left" bgColor="#405080" style = "color:#ffffff;text-align:center;">UpsID</th>
			<th class="LargeBold" width="20" align="left" bgColor="#405080" style = "color:#ffffff;text-align:center;">Code</th>
			<th class="LargeBold" width="200" align="left" bgColor="#405080" style = "color:#ffffff;text-align:center;">Event</th>
			<th class="LargeBold" width="20" align="left" bgColor="#405080" style = "color:#ffffff;text-align:center;">State</th>
		</tr>
		<xsl:for-each select="event">
			<tr>
				<td width="200" class="Medium" style = "background-color:#f1f1f1; color:#405080;text-align:center;"><xsl:value-of select='@time'/></td>
				<td width="20" class="Medium" style = "background-color:#f1f1f1;color:#405080;text-align:center;"><xsl:value-of select='@upsid'/></td>
				<td width="20" class="Medium" style = "background-color:#f1f1f1;color:#405080;text-align:center;"><xsl:value-of select='@code'/></td>
				<td width="200"  class="Medium" style = "background-color:#f1f1f1;color:#405080;text-align:left;">
				<xsl:call-template name="text">
						<xsl:with-param name="code" select='string(@code)'/>
					</xsl:call-template>
				</td>
				<td width="20"  class="Medium" style = "background-color:#f1f1f1;color:#405080;text-align:right;"><xsl:value-of select='@status'/></td>
			</tr>
		</xsl:for-each>
	
	</tbody></table>
	<br/>
	</center>
</xsl:template>

<xsl:template name="text">
	<xsl:param name="code" select="'0'"/>	
	<xsl:for-each select="document('eventtexts.xml')/eventtexte/eventtext[@code = $code]">
		<xsl:value-of select="."/>
	</xsl:for-each>
</xsl:template>
</xsl:stylesheet>