<?xml version="1.0"?>
<!--
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method = "html" encoding="ISO-8859-1" indent="yes"/>

<xsl:template match="/">
<html>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
<title>UPSMAN Logfile</title>
<body style="font-family:Arial,helvetica,sans-serif;font-size:12pt; background-color:#EEEEEE">

<div style="background-color:teal;color:white;padding:8px; width:480px; height:20px">
<span style="font-weight:bold;color:white;font-size:14pt;">
UPSMAN Log file
</span>
</div>

<br/>

<div style="background-color:gold;color:white;padding:4px;width:480px">
<span style="font-weight:bold;color:white">
UPS Identification<br/>
</span>
</div>
<xsl:for-each select="UpsLog/UpsIdent">
<table border="0">
	<tr>
		<td style="font-size:10pt">Location:</td>
		<td style="font-size:10pt"><xsl:value-of select="Location" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Model:</td>
		<td style="font-size:10pt"><xsl:value-of select="Model" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Identification: </td>
		<td style="font-size:10pt"><xsl:value-of select="Identification" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Company: </td>
		<td style="font-size:10pt"><xsl:value-of select="Company" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Contact: </td>
		<td style="font-size:10pt"><xsl:value-of select="Contact" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">City: </td>
		<td style="font-size:10pt"><xsl:value-of select="City" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Street: </td>
		<td style="font-size:10pt"><xsl:value-of select="Street" /></td>
	</tr>
	<tr>
		<td style="font-size:10pt">Phone: </td>
		<td style="font-size:10pt"><xsl:value-of select="Phone" /></td>
	</tr>

</table>
</xsl:for-each>

<br/>

<div style="background-color:gold;color:white;padding:4px;width:480px">
<span style="font-weight:bold;color:white">
UPS Events<br/>
</span>
</div>
<br/>
<div style="font-size:8pt">
<table border="1" cellspacing="0" cellpadding="2" width="480">
<tr>
	<th style="font-size:8pt;text-align:center;">No.</th>
	<th style="font-size:8pt;text-align:center;">Date</th>
	<th style="font-size:8pt;">Time</th>
	<th style="font-size:8pt;">Text</th>

</tr>

<xsl:for-each select="UpsLog/UpsEvents/Entry">

<tr>
	<td style="font-size:8pt;" align="center"><xsl:value-of select="./@id"/></td>
	<td style="font-size:8pt;" align="center"><xsl:value-of select="Date"/></td>
	<td style="font-size:8pt;" align="center"><xsl:value-of select="Time"/></td>
	<td style="font-size:8pt;" align ="left"><xsl:value-of select="Text"/></td>
</tr>
</xsl:for-each>
</table>
</div>

</body>
</html>
</xsl:template>
</xsl:stylesheet>
