# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
this project does not adhere to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).
Minor updates to resources keep the same version and only show a newer build date.
Updates to the installer itself, or major feature updates will be reflected in an incremented version string.
Developer versions have uneven minor version numbers. Stable versions are even.

## [Unreleased]

## [4.40] - 2022-07-04

### Security

  - Updated Jetty to version 9.4.48 v.20220622
  - Added new configuration option to enable UDP broadcast messages for RCCMD. Default is off. Used to be enabled automatically.
    Until now it is only enabled and supported by RCCMD on Windows. Others are meant to follow before next release!

### Changed
  
  - RCCMD Installer Windows: Added more translations for German
  - RCCMD Installer Windows: created shortcuts will start windows config tool, if Web Config is deselected

## [4.38] - 2022-01-14

### Security

  - Updated Jetty to version 9.4.44 v.20210927 to resolve CVE-2021-34429 (https://github.com/advisories/GHSA-vjv5-gp2w-65vm)
  - Updated Java JRE to 17.0.1 for platforms: Lin x64, Windows, MacOS

## [4.36] - 2021-07-13

### Security

  - Updated JQuery lib used in RCCMD Web Configuration to version 3.6.0.

## [4.36] - 2021-07-07

### Security

  - A vulnerability (https://nvd.nist.gov/vuln/detail/CVE-2021-28165) in the used version of Webserver Eclipse-Jetty (9.4.27-20200227) has been found.
    RCCMDWebIf has switched to the current version of Eclipse-Jetty (9.4.42.v20210604).

## [4.36] - 2021-06-22

### Security

  - On VMware-Appliance RCCMD Web Configuration now uses dummy password for credentials, when transmitting stored server data.
    Server password entry is required for all server data updates to be made.
  
### Added

  - Support for Mac OS X Big Sur (v 11.3)

### Changed

  - Installer Engine switched from InstallAnywhere to InstallBuilder. This also brought a new installer user experience.
  - New default installation path in Linux is /opt/rccmd

## [4.34] - 2020-12-11

### Changed

  - Enhanced user experience

## [4-32] - 2021-02-10

### Security

  - update to underlying Debian system of 'RCCMD Appliance' due to 
  ```
  Debian Security Advisory
  DSA-4839-1 sudo -- security update
  ```

## [4.32] - 2020-10-21

### Changed

  - Set Web Configuration Password during installation.

### Fixed

  - Use a 32bit Java Runtime for Installer to also work on 32Bit Windows systems
  - Windows: start RCCMDTray at System start.
  - Added missing dialog translations.

## [4.30] - 2020-07-28

### Changed

  - Switched Installer Buildtools from InstallAnywhere to Installbuilder

### Added

  - New Feature for RCCMD on Vmware ESXi: option to suspend VMs rather than shutdown

## [4.28] - 2020-04-24

### Fixed 

  - Introduced whitelist of files RCCMDWebIf can read and write

## [4.26] - 2020-04-17

### Fixed

- For VMware-Appliance RCCMDWebIf: on page "VMware Settings" the button "Save Changes" did not turn blue again after saving, if an Error or Warning was generated. This gave the false impression the changes might not have been saved. Now the button turns blue again properly.
- For VMware-Appliance: The shutdown_freeESXi.sh did not propagate the dry-run flag correctly. It does now.

### Changed

- RCCMDWebIf: On page Options -> "Notification Settings" removed E-Mail notifications. Feature still works for Clients who use it and have configured it. New Users are recommended to use E-Mail feature within CS141 rather than RCCMD.

## [4.24] - 2020-02-21

### Fixed

- Fixed bug in shutdown script for VMware ESXi. If no VSAN is in use VMs would be sent shutdown signal twice in immediate succession, which resulted in forced shutdown of machines that had already terminated VMware Tools after first signal. Second signal now only comes in case of VSAN and after RESYNC_TIMEOUT - meant mainly for vCenter Server. 
- Fixed bug in shutdown script for VMware ESXi. Under some circumstances VMs would be shutdown when they should be migrated away via vMotion. Maintenace Mode for ESXi Hosts was triggered via the Host directly. Now it is triggered via vCenter Server.

## [4.24] - 2019-11-19

### Security

- Updated internal webserver Jetty to version 9.4.22.v20191022

### Fixed

- Bugfix: loss of licensekey, on change of Advanced Settings

## [4.22] - 2019-08-09

### Fixed

- WebConfig: Certain combinations of special characters in passwords could not be set.
- Linux Installers: removed error because of missing dynamic libraries on certain systems.

### Changed

- WebConfig: Set minimum password length to five characters.

## [4.20] - 2019-07-19

### Added

- Support to shutdown VMware vSAN environment
- Tooltip revealing default password in login dialog if wrong password is entered. This should help new users get started.
- Browser compatibility check
- Eula displayed in webif
- Password change also sets new password for linux user in RCCMDAppliance for VMware
- Set default shutdown time for ESXi Hosts to 90 seconds.
- Mutli language support in webif
- Individual OEM Logos, background

### Changed

- Display license agreement before uninstall old version
- Default password for webif is now: "RCCMD"
- On Mac check for admin privileges during install
- Replaced old design of user interface with new one
- Updated version of used libraries: bootstrap 4.1
- Removed VMware recognition from installer. ESXi 6.0 - 6.5 support removed from installer. Refer to older installers.
  ESXi 6.7 support provided via new Appliance with preinstalled RCCMD
- Updated Acknowledgements
- VMware Settings are now accepted "as is" without verification. Now configuration is possible, without the need for Hosts to be available.

### Fixed

- Hints on forms in web interface
- Rccmd.log is downloadable from Windows host too
- Show own - more helpful - error messages instead of connection error messages from api scripts
- Adding same ESXi Host more than once
- Accept emtpy config for email for Windows Host
- Heartbeats config problem

## [4.18] - 2018-03-02

### Added

- Acknowledgements
- Shutdown Settings accepts IP ranges
- Reorder commands in Shutdown Settings
- Connections page denies IPv6 addresses
- Option to set License key
- Dry-run for shutdown scripts on VMware
- Display of all shutdown logs on VMware

### Security

- Upgraded used Jetty to version 9.4.7
- Upgraded jQuery to 3.3.1

### Fixed

- Mangling of login passwords for VMware Hosts in certain cases

## [4.16] - 2017-03-01

### Security

- Upgraded Java jre used by installer from 1.7 to 1.8
